create or replace package tbicds.PCK_REFERRAL_CLINIC
AUTHID CURRENT_USER
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  type RetRefCursor is ref cursor;

  procedure GetReferralClinicRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nStatReferralID  in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  procedure GetReferralClinicLookUpRS(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2,
                                      rs                  out RetRefCursor);

  procedure InsertReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nReferralID    out number,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2);

  procedure UpdateReferralClinic(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_nReferralID      in number,
                                 pi_vReferralDesc    in varchar2,
                                 pi_vReferralText    in varchar2,
                                 pi_vProviderName in varchar2,
                                 pi_vAddress      in varchar2,
                                 pi_vCity         in varchar2,
                                 pi_nStateID      in number,
                                 pi_vPostalCode   in varchar2,
                                 pi_vPhone        in varchar2,
                                 pi_vFax          in varchar2,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2);

  procedure DiscontinueReferralClinic(pi_vSessionID       in varchar2,
                                      pi_vSessionClientIP in varchar2,
                                      pi_nUserID          in number,
                                      pi_nReferralID      in number,
                                      po_nStatusCode      out number,
                                      po_vStatusComment   out varchar2);

end;
/

